
# Accelerometer Vector Magnitude App Note Example

import FXLS8471Q
import aardvark_setup
from aardvark_py import *
import time
import math
from config import *

# Print Revision

print "AN4692 SW Rev: " + str(REVISION)

# Setup Aardvark

(handle, INT1_PIN) = aardvark_setup.setup_aardvark()

# Update aardvark handle in FXLS8471Q.py

FXLS8471Q.handle = handle

# Reset 

FXLS8471Q.reset_FXLS8471Q()

# 0.3G
# A_VECM_THS_MSB, LSB  = 0x84CC => 1228 *0.224mg = ~300mg
# 0x8000 designates the debounce behavior

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x60, 0x84] ) # write 0x84 to reg 0x60
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x61, 0xCC] )

# A_VECM_CNT = 1 * (1/12.5Hz) = 80ms (see datasheet table 96)

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x62, 0x01] )

# A_VECM_INITX/Y/Z
# Set Z only as 1g

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x63, 0x00] )
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x64, 0x00] )

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x65, 0x00] )
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x66, 0x00] )

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x67, 0x10] )
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x68, 0x00] )

# A_VECM_CFG
# a_vecm_ele = 1 => event latching enabled
# a_vecm_initm = 1 => use A_VECM_INITX/Y/Z as initial reference
# a_vecm_updm = 1 => do not update initial reference
# a_vecm_en = 1 => enable acceleration vector magnitude detection feature

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x5F, 0x78] )

# enable interrupts for the feature using CTRL_REG4

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x2D, 0x02] )

# route interrupts to INT1 pin using CTRL_REG5
    
FXLS8471Q.write_byte_FXLS8471Q_chk( [0x2E, 0x02] )

# Enable device with ODR = 12.5Hz, OSR=NORMAL 

FXLS8471Q.write_byte_FXLS8471Q_chk( [0x2A, 0x29] )

# Wait for INT1 to assert and clear interrupt by reading register 
# INT_SOURCE (0x0C)		

while( True ):
            
    transition = aa_gpio_change( handle, 100 )

    if (transition & INT1_PIN ) == INT1_PIN:
        print "No interrupt..."
        continue

    print "Interrupt occured!!!"
    (count, dataIn) = FXLS8471Q.read_FXLS8471Q( 0x0C, 1 ) 
    print "0x0C =0x%X" % dataIn[0]
